<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\LegalCase;
use Illuminate\Http\Request;

class CalendarController extends Controller
{

    public function index(Request $request)
    {
        $cases = LegalCase::with('client')
            ->whereNotNull('court_date')
            ->get();

        $events = $cases->map(function ($case) {
            return [
                'id'    => $case->id,
                'title' => "⚖️ {$case->case_number} - {$case->client->name}",
                'start' => $case->court_date->toIso8601String(),
                'url'   => route('admin.cases.show', $case->id),
                'extendedProps' => [
                    'description' => "Title: {$case->title} | Status: " . ucfirst($case->status),
                ],
            ];
        });

        return response()->json($events);
    }


    // public function index(Request $request)
    // {
    //     if ($request->ajax()) {
    //         // Eager load 'client' to prevent N+1 query issues
    //         $cases = LegalCase::with('client')
    //             ->whereNotNull('court_date')
    //             ->get();

    //         $events = $cases->map(function ($case) {
    //             return [
    //                 'id'    => $case->id,
    //                 'title' => "⚖️ {$case->case_number} - {$case->client->name}",
    //                 'start' => $case->court_date->toIso8601String(),
    //                 'url'   => route('admin.cases.show', $case->id),
    //                 'extendedProps' => [
    //                     'description' => "Title: {$case->title} | Status: " . ucfirst($case->status),
    //                 ]
    //             ];
    //         });

    //         return response()->json($events);
    //     }

    //     return view('admin.calendar.index');
    // }

    // public function index(Request $request)
    // {
    //     // If the request is an AJAX call (from FullCalendar), return JSON
    //     if ($request->ajax()) {

    //         // Fetch cases that have a court date set
    //         $cases = LegalCase::whereNotNull('court_date')
    //                           ->where('status', '!=', 'closed')
    //                           ->get();

    //         $events = [];

    //         foreach ($cases as $case) {
    //             $events[] = [
    //                 'title' => '⚖️ ' . $case->case_number, // e.g. "⚖️ CIV-2026-001"
    //                 'start' => $case->court_date->format('Y-m-d'), // FullCalendar needs YYYY-MM-DD
    //                 'url' => route('admin.cases.show', $case->id), // Click to go to case file
    //                 'backgroundColor' => '#ef4444', // Red for court dates
    //                 'borderColor' => '#ef4444',
    //                 'extendedProps' => [
    //                     'description' => $case->title // Extra info for hover
    //                 ]
    //             ];
    //         }

    //         return response()->json($events);
    //     }

    //     return view('admin.calendar.index');
    // }
}
