<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CaseNote;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\ActivityLog;

class CaseNoteController extends Controller
{
    public function store(Request $request, $caseId)
    {
        $request->validate([
            'content' => 'required|string',
            'type' => 'required|in:note,call,hearing,email',
            'activity_date' => 'nullable|date',
        ]);

      $case=  CaseNote::create([
            'legal_case_id' => $caseId,
            'user_id' => Auth::id(),
            'content' => $request->content,
            'type' => $request->type,
            'activity_date' => $request->activity_date ?? now(),
            'is_visible_to_client' => $request->has('is_visible_to_client'),
        ]);

        ActivityLog::record('Create', 'Case', "Opened new case {$case->case_number}");

        return back()->with('success', 'Timeline updated.');
    }
}
