<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Witness;
use Illuminate\Http\Request;

class WitnessController extends Controller
{
    public function store(Request $request, $caseId)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|in:plaintiff,defense,expert,eyewitness',
            'statement' => 'nullable|string',
        ]);

        Witness::create([
            'legal_case_id' => $caseId,
            'name' => $request->name,
            'phone' => $request->phone,
            'type' => $request->type,
            'statement' => $request->statement,
        ]);

        return back()->with('success', 'Witness added to the case file.');
    }

    public function destroy(Witness $witness)
    {
        $witness->delete();
        return back()->with('success', 'Witness removed.');
    }
}
