<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Document extends Model
{
    use HasFactory;

    protected $fillable = ['legal_case_id', 'user_id', 'title', 'file_path', 'file_type', 'file_size'];

    public function uploader()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function legalCase()
    {
        return $this->belongsTo(LegalCase::class, 'legal_case_id');
    }
}
