<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up(): void
{
    Schema::create('legal_cases', function (Blueprint $table) {
        $table->id();

        // Identification
        $table->string('case_number')->unique(); // e.g. "CIV-2026-004"
        $table->string('title'); // e.g. "Land Dispute: Plot 45"
        $table->text('description')->nullable();

        // Relationships
        // We use 'users' table for both, but roles distinguish them
        $table->foreignId('client_id')->constrained('users')->onDelete('cascade');
        $table->foreignId('assigned_lawyer_id')->constrained('users')->onDelete('cascade');

        // Status & Details
        $table->enum('status', ['open', 'hearing', 'pending', 'closed', 'archived'])->default('open');
        $table->enum('priority', ['low', 'medium', 'high', 'critical'])->default('medium');
        $table->date('court_date')->nullable();
        $table->decimal('retainer_fee', 10, 2)->default(0.00); // For billing later

        $table->softDeletes(); // Never permanently delete legal data
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('legal_cases');
    }
};
