<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up(): void
{
    Schema::create('documents', function (Blueprint $table) {
        $table->id();
        $table->foreignId('legal_case_id')->constrained('legal_cases')->onDelete('cascade');
        $table->foreignId('user_id')->constrained('users'); // Who uploaded it?
        $table->string('title');     // e.g. "Signed Contract"
        $table->string('file_path'); // e.g. "documents/abc.pdf"
        $table->string('file_type'); // e.g. "pdf"
        $table->integer('file_size'); // in KB
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('documents');
    }
};
