<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
   public function up()
{
    Schema::table('legal_cases', function (Blueprint $table) {
        // Court Details
        $table->string('court_name')->nullable();      // e.g. Milimani High Court
        $table->string('judge_name')->nullable();      // e.g. Justice Mwangi
        $table->string('case_stage')->default('Pre-Trial'); // e.g. Mention, Hearing, Judgment

        // Opposing Side
        $table->string('opposing_counsel')->nullable(); // e.g. Ochieng & Associates

        // Police Info (For Criminal/Traffic cases)
        $table->string('police_station')->nullable();   // e.g. Kilimani Police Station
        $table->string('police_ob_number')->nullable(); // e.g. OB/12/05/2026

        $table->foreignId('assigned_advocate_id')->nullable()->constrained('users');
    });
}

public function down()
{
    Schema::table('legal_cases', function (Blueprint $table) {
        $table->dropColumn(['court_name', 'judge_name', 'case_stage', 'opposing_counsel', 'police_station', 'police_ob_number']);
    });
}
};
