<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->id();
            $table->string('title'); // e.g., "Consultation with John"
            $table->dateTime('start_time');
            $table->dateTime('end_time');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // The Lawyer
            $table->foreignId('client_id')->nullable()->constrained('users')->onDelete('cascade'); // Optional Client
            $table->foreignId('legal_case_id')->nullable()->constrained()->onDelete('cascade'); // Optional Case Link
            $table->string('location')->nullable(); // e.g., "Office", "Zoom", "High Court"
            $table->enum('status', ['scheduled', 'completed', 'cancelled'])->default('scheduled');
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('appointments');
    }
};
