<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('chart_of_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., "Legal Fees"
            $table->string('code')->nullable(); // e.g., "4000"
            // Categorize specifically for law firms
            $table->enum('type', ['income', 'expense', 'asset', 'liability', 'equity']);
            $table->boolean('is_system')->default(false); // Protect default accounts
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chart_of_accounts');
    }
};
