<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('payments', function (Blueprint $table) {
            // 1. Allow payments without invoices (e.g. Direct Deposits)
            $table->foreignId('invoice_id')->nullable()->change();

            // 2. Add direct Client Link (for deposits)
            $table->foreignId('client_id')->nullable()->constrained('users');

            // 3. Link to Chart of Accounts (The "Why")
            $table->foreignId('chart_of_account_id')->nullable()->constrained();
        });
    }

    public function down()
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->foreignId('invoice_id')->nullable(false)->change();
            $table->dropForeign(['client_id']);
            $table->dropColumn('client_id');
            $table->dropForeign(['chart_of_account_id']);
            $table->dropColumn('chart_of_account_id');
        });
    }
};
