<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AccountsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
   public function run()
{
    $accounts = [
        // INCOME (Revenue)
        ['name' => 'Legal Fees', 'code' => '4000', 'type' => 'income', 'description' => 'Professional fees charged to clients.'],
        ['name' => 'Consultation Fees', 'code' => '4001', 'type' => 'income', 'description' => 'One-off meeting charges.'],

        // EXPENSES (Costs)
        ['name' => 'Court Filing Fees', 'code' => '5000', 'type' => 'expense', 'description' => 'Standard court payments.'],
        ['name' => 'Disbursements', 'code' => '5001', 'type' => 'expense', 'description' => 'Recoverable costs incurred on behalf of client.'],
        ['name' => 'Travel & Transport', 'code' => '5002', 'type' => 'expense', 'description' => 'Taxi, fuel, flights for cases.'],

        // LIABILITIES (Client Money / Judgment Sums)
        // Note: Judgment sums are usually money HELD for a client, so they are a LIABILITY until paid out.
        ['name' => 'Client Account (Judgment Sums)', 'code' => '2000', 'type' => 'liability', 'description' => 'Money held in trust for clients (Decretal sums).'],
        ['name' => 'VAT Payable', 'code' => '2001', 'type' => 'liability', 'description' => 'Tax collected to be remitted to KRA.'],
    ];

    foreach ($accounts as $acc) {
        \App\Models\ChartOfAccount::create($acc);
    }
}
}
