<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class LandlordSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if the landlord already exists to avoid duplicate errors
        if (!User::where('email', 'yousaf@legalpro.test')->exists()) {
            User::create([
                'name' => 'Yousaf (SaaS Admin)',
                'email' => 'yousaf@legalpro.test',
                'password' => Hash::make('password'), // Change this for production!
                'role' => 'super_admin',
            ]);

            $this->command->info('Landlord user created successfully.');
        } else {
            $this->command->warn('Landlord user already exists.');
        }
    }
}
