<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-2">
                <i class="ph-duotone ph-briefcase text-indigo-600"></i>
                {{ __('Legal Matters') }}
            </h2>
            <span class="text-sm font-medium text-slate-500 bg-white px-3 py-1 rounded-full border shadow-sm">
                Total Cases: {{ $cases->total() }}
            </span>
        </div>
    </x-slot>

    <div class="py-10 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <div class="flex flex-col sm:flex-row justify-between items-center mb-6 gap-4">

                <div class="relative w-full sm:w-72">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="ph-bold ph-magnifying-glass text-slate-400"></i>
                    </div>
                    <input type="text" placeholder="Search case no, client..."
                        class="w-full pl-10 pr-4 py-2.5 rounded-xl border-slate-200 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-sm bg-white placeholder-slate-400 transition-all">
                </div>

                <a href="{{ route('admin.cases.create') }}"
                    class="w-full sm:w-auto bg-slate-900 text-white px-5 py-2.5 rounded-xl hover:bg-indigo-600 flex items-center justify-center gap-2 shadow-lg shadow-indigo-500/20 transition-all transform hover:scale-105 font-medium text-sm">
                    <i class="ph-bold ph-plus-circle text-lg"></i>
                    Open New Matter
                </a>
            </div>

            <div class="bg-white overflow-hidden shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-slate-100">
                        <thead class="bg-slate-50/50">
                            <tr>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-bold text-slate-500 uppercase tracking-wider">Case File</th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-bold text-slate-500 uppercase tracking-wider">Client</th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-bold text-slate-500 uppercase tracking-wider">Advocate</th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-bold text-slate-500 uppercase tracking-wider">Status</th>
                                <th scope="col" class="px-6 py-4 text-right text-xs font-bold text-slate-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-100 bg-white">
                            @forelse($cases as $case)
                                <tr class="hover:bg-slate-50/80 transition-colors group">

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-start gap-3">
                                            <div class="h-10 w-10 rounded-lg bg-indigo-50 text-indigo-600 flex items-center justify-center flex-shrink-0">
                                                <i class="ph-duotone ph-folder-open text-xl"></i>
                                            </div>
                                            <div>
                                                <div class="text-sm font-bold text-slate-800">{{ $case->title }}</div>
                                                <div class="text-xs font-mono text-slate-500 mt-0.5">{{ $case->case_number }}</div>
                                            </div>
                                        </div>
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center gap-2">
                                            <div class="h-6 w-6 rounded-full bg-emerald-100 text-emerald-700 flex items-center justify-center text-[10px] font-bold">
                                                {{ substr($case->client->name, 0, 1) }}
                                            </div>
                                            <span class="text-sm text-slate-600 font-medium">{{ $case->client->name }}</span>
                                        </div>
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center gap-2">
                                            <i class="ph-duotone ph-user-circle text-slate-400 text-lg"></i>
                                            <span class="text-sm text-slate-600">{{ $case->lawyer->name }}</span>
                                        </div>
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @php
                                            $styles = match ($case->status) {
                                                'open'    => 'bg-emerald-50 text-emerald-700 border-emerald-100 ring-emerald-600/20',
                                                'hearing' => 'bg-amber-50 text-amber-700 border-amber-100 ring-amber-600/20',
                                                'closed'  => 'bg-slate-50 text-slate-600 border-slate-100 ring-slate-500/20',
                                                'pending' => 'bg-blue-50 text-blue-700 border-blue-100 ring-blue-600/20',
                                                default   => 'bg-gray-50 text-gray-600 border-gray-100 ring-gray-500/20',
                                            };
                                        @endphp
                                        <span class="inline-flex items-center rounded-md px-2 py-1 text-xs font-medium ring-1 ring-inset {{ $styles }}">
                                            <span class="w-1.5 h-1.5 rounded-full bg-current opacity-50 mr-1.5"></span>
                                            {{ ucfirst($case->status) }}
                                        </span>
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <div class="flex items-center justify-end gap-3 opacity-100 sm:opacity-0 group-hover:opacity-100 transition-opacity">
                                            <button onclick="openDescriptionModal('{{ addslashes($case->title) }}', `{{ addslashes($case->description) }}`)"
                                                class="text-slate-400 hover:text-indigo-600 transition-colors" title="Read Facts">
                                                <i class="ph-bold ph-notebook text-lg"></i>
                                            </button>

                                            <a href="{{ route('admin.cases.show', $case->id) }}" class="text-slate-400 hover:text-indigo-600 transition-colors" title="View Details">
                                                <i class="ph-bold ph-eye text-lg"></i>
                                            </a>

                                            <a href="{{ route('admin.cases.edit', $case->id) }}" class="text-slate-400 hover:text-amber-600 transition-colors" title="Edit Case">
                                                <i class="ph-bold ph-pencil-simple text-lg"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-12 text-center">
                                        <div class="flex flex-col items-center justify-center">
                                            <div class="bg-slate-50 rounded-full p-4 mb-3">
                                                <i class="ph-duotone ph-folder-notch-open text-3xl text-slate-300"></i>
                                            </div>
                                            <h3 class="text-slate-900 font-medium">No cases found</h3>
                                            <p class="text-slate-500 text-sm mt-1">Get started by opening a new legal matter.</p>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                @if($cases->hasPages())
                    <div class="bg-slate-50 border-t border-slate-100 px-6 py-3">
                        {{ $cases->links() }}
                    </div>
                @endif
            </div>

        </div>
    </div>

    <div id="descModal" class="fixed inset-0 z-50 hidden transition-opacity duration-300" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="fixed inset-0 bg-slate-900/60 backdrop-blur-sm transition-opacity" onclick="closeDescriptionModal()"></div>

        <div class="fixed inset-0 z-10 overflow-y-auto">
            <div class="flex min-h-full items-end justify-center p-4 text-center sm:items-center sm:p-0">

                <div class="relative transform overflow-hidden rounded-2xl bg-white text-left shadow-2xl transition-all sm:my-8 sm:w-full sm:max-w-lg border border-slate-100">

                    <div class="bg-slate-50 px-4 py-3 sm:px-6 flex justify-between items-center border-b border-slate-100">
                        <h3 class="text-base font-bold leading-6 text-slate-900 flex items-center gap-2" id="modalTitle">
                            Case Facts
                        </h3>
                        <button type="button" onclick="closeDescriptionModal()" class="rounded-md bg-white text-slate-400 hover:text-red-500 focus:outline-none">
                            <i class="ph-bold ph-x text-lg"></i>
                        </button>
                    </div>

                    <div class="px-4 py-5 sm:p-6 max-h-[60vh] overflow-y-auto">
                        <div class="prose prose-sm prose-slate text-slate-600">
                            <p id="modalContent">No description available.</p>
                        </div>
                    </div>

                    <div class="bg-slate-50 px-4 py-3 sm:flex sm:flex-row-reverse sm:px-6 border-t border-slate-100">
                        <button type="button" onclick="closeDescriptionModal()" class="mt-3 inline-flex w-full justify-center rounded-lg bg-white px-3 py-2 text-sm font-semibold text-slate-900 shadow-sm ring-1 ring-inset ring-slate-300 hover:bg-slate-50 sm:mt-0 sm:w-auto">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

<script>
    function openDescriptionModal(title, desc) {
        document.getElementById('modalTitle').innerText = title;
        // Check if desc is null, undefined, or string 'null'
        if (!desc || desc === 'null') {
            document.getElementById('modalContent').innerText = 'No description or facts recorded for this case.';
        } else {
            document.getElementById('modalContent').innerText = desc;
        }
        document.getElementById('descModal').classList.remove('hidden');
    }

    function closeDescriptionModal() {
        document.getElementById('descModal').classList.add('hidden');
    }
</script>
