<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-2">
                <i class="ph-duotone ph-users-three text-indigo-600"></i>
                {{ __('Client Directory') }}
            </h2>
            <a href="{{ route('admin.clients.create') }}" class="bg-indigo-600 text-white px-5 py-2 rounded-lg text-sm font-bold hover:bg-indigo-700 shadow-lg shadow-indigo-200 transition flex items-center gap-2">
                <i class="ph-bold ph-user-plus"></i> New Client
            </a>
        </div>
    </x-slot>

    <div class="py-10 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <div class="mb-6 max-w-md">
                <div class="relative">
                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="ph-bold ph-magnifying-glass text-slate-400"></i>
                    </span>
                    <input type="text" placeholder="Search by name, email or phone..."
                        class="w-full pl-10 pr-4 py-2.5 rounded-xl border-slate-200 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-sm bg-white">
                </div>
            </div>

            <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-slate-100">
                        <thead class="bg-slate-50/50">
                            <tr>
                                <th class="px-6 py-4 text-left text-xs font-bold text-slate-500 uppercase tracking-wider">Client Identity</th>
                                <th class="px-6 py-4 text-left text-xs font-bold text-slate-500 uppercase tracking-wider">Contact Info</th>
                                <th class="px-6 py-4 text-left text-xs font-bold text-slate-500 uppercase tracking-wider">Active Matters</th>
                                <th class="px-6 py-4 text-left text-xs font-bold text-slate-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-4 text-right text-xs font-bold text-slate-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-100 bg-white">
                            @forelse($clients as $client)
                                <tr class="hover:bg-slate-50/80 transition group">

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center gap-3">
                                            <div class="h-10 w-10 rounded-full bg-slate-100 flex items-center justify-center text-slate-600 text-sm font-bold ring-2 ring-white shadow-sm">
                                                {{ substr($client->name, 0, 1) }}
                                            </div>
                                            <div>
                                                <div class="text-sm font-bold text-slate-800">{{ $client->name }}</div>
                                                <div class="text-xs text-slate-400">Added {{ $client->created_at->format('M Y') }}</div>
                                            </div>
                                        </div>
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex flex-col gap-1">
                                            <div class="flex items-center gap-2 text-xs text-slate-600">
                                                <i class="ph-fill ph-envelope-simple text-slate-400"></i> {{ $client->email }}
                                            </div>
                                            <div class="flex items-center gap-2 text-xs text-slate-600">
                                                <i class="ph-fill ph-phone text-slate-400"></i> {{ $client->phone ?? 'N/A' }}
                                            </div>
                                        </div>
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @if($client->cases_count > 0)
                                            <a href="{{ route('admin.clients.show', $client->id) }}" class="inline-flex items-center gap-1.5 px-3 py-1 rounded-full text-xs font-bold bg-indigo-50 text-indigo-700 border border-indigo-100 hover:bg-indigo-100 transition group/badge">
                                                <i class="ph-fill ph-briefcase"></i>
                                                {{ $client->cases_count }} Case Files
                                                <i class="ph-bold ph-arrow-right opacity-0 group-hover/badge:opacity-100 transition-opacity -mr-1"></i>
                                            </a>
                                        @else
                                            <span class="inline-flex items-center gap-1.5 px-3 py-1 rounded-full text-xs font-medium bg-slate-100 text-slate-500 border border-slate-200">
                                                No Active Cases
                                            </span>
                                        @endif
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full text-xs font-bold border bg-emerald-50 text-emerald-700 border-emerald-100">
                                            <span class="h-1.5 w-1.5 rounded-full bg-emerald-500"></span> Active
                                        </span>
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <div class="flex items-center justify-end gap-2">
                                            <a href="{{ route('admin.clients.show', $client->id) }}"
                                               class="text-slate-400 hover:text-indigo-600 p-2 rounded-lg hover:bg-indigo-50 transition" title="View Profile">
                                                <i class="ph-bold ph-eye text-lg"></i>
                                            </a>
                                            <a href="{{ route('admin.clients.edit', $client->id) }}"
                                               class="text-slate-400 hover:text-amber-600 p-2 rounded-lg hover:bg-amber-50 transition" title="Edit Client">
                                                <i class="ph-bold ph-pencil-simple text-lg"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-12 text-center">
                                        <div class="bg-slate-50 rounded-full h-12 w-12 flex items-center justify-center mx-auto mb-3">
                                            <i class="ph-duotone ph-users-three text-2xl text-slate-300"></i>
                                        </div>
                                        <h3 class="text-slate-900 font-medium">No clients found</h3>
                                        <p class="text-slate-500 text-sm mt-1">Add a new client to get started.</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                @if($clients->hasPages())
                    <div class="bg-slate-50 border-t border-slate-100 px-6 py-3">
                        {{ $clients->links() }}
                    </div>
                @endif
            </div>

        </div>
    </div>
</x-app-layout>
