<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-2">
                <i class="ph-duotone ph-books text-indigo-600"></i> Chart of Accounts
            </h2>
            <a href="{{ route('admin.finance.index') }}" class="text-sm font-bold text-slate-500 hover:text-indigo-600 flex items-center gap-1">
                <i class="ph-bold ph-arrow-left"></i> Back to Finance
            </a>
        </div>
    </x-slot>

    <div class="py-10 bg-slate-50 min-h-screen" x-data="{ editModal: false, editData: {} }">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 grid grid-cols-1 lg:grid-cols-3 gap-8">

            <div class="lg:col-span-1">
                <div class="bg-white p-6 rounded-2xl shadow-sm ring-1 ring-slate-900/5 sticky top-6 border-t-4 border-indigo-500">
                    <h3 class="font-bold text-lg text-slate-800 mb-4 flex items-center gap-2">
                        <i class="ph-duotone ph-plus-circle text-indigo-600"></i> New Account
                    </h3>

                    <form action="{{ route('admin.accounts.store') }}" method="POST">
                        @csrf
                        <div class="space-y-4">
                            <div>
                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Account Name</label>
                                <input type="text" name="name" class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="e.g. Office Rent" required>
                            </div>

                            <div>
                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Category</label>
                                <select name="type" class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 bg-slate-50">
                                    <option value="income">Income (Revenue)</option>
                                    <option value="expense">Expense (Operational Cost)</option>
                                    <option value="liability">Liability (Client Funds/VAT)</option>
                                    <option value="asset">Asset (Equipment/Bank)</option>
                                    <option value="equity">Equity</option>
                                </select>
                            </div>

                            <div>
                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1">GL Code (Optional)</label>
                                <input type="text" name="code" class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="e.g. 5005">
                                <p class="text-[10px] text-slate-400 mt-1">Unique identifier for reporting.</p>
                            </div>

                            <div>
                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Description</label>
                                <textarea name="description" rows="2" class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="What is this for?"></textarea>
                            </div>

                            <button type="submit" class="w-full bg-slate-900 text-white py-2.5 rounded-lg font-bold hover:bg-slate-800 transition shadow-lg">
                                Create Account
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="lg:col-span-2 space-y-6">

                @foreach(['income' => 'Revenue & Income', 'expense' => 'Expenses & Costs', 'liability' => 'Liabilities (Client Accounts)', 'asset' => 'Assets', 'equity' => 'Equity'] as $type => $label)
                    @if(isset($accounts[$type]))
                    <div class="bg-white overflow-hidden rounded-2xl shadow-sm ring-1 ring-slate-900/5">
                        <div class="px-6 py-4 bg-slate-50 border-b border-slate-100 flex items-center justify-between">
                            <h4 class="font-bold text-slate-700 uppercase tracking-wide text-xs flex items-center gap-2">
                                <span class="h-2 w-2 rounded-full {{ $type == 'income' ? 'bg-emerald-500' : ($type == 'expense' ? 'bg-red-500' : 'bg-amber-500') }}"></span>
                                {{ $label }}
                            </h4>
                            <span class="text-[10px] font-bold bg-white border px-2 py-0.5 rounded text-slate-500">{{ count($accounts[$type]) }} Items</span>
                        </div>
                        <table class="min-w-full text-left text-sm">
                            <tbody class="divide-y divide-slate-100">
                                @foreach($accounts[$type] as $acc)
                                <tr class="hover:bg-slate-50 transition group">
                                    <td class="px-6 py-3 font-mono text-slate-400 text-xs w-16">{{ $acc->code ?? '---' }}</td>
                                    <td class="px-6 py-3">
                                        <p class="font-bold text-slate-800">{{ $acc->name }}</p>
                                        <p class="text-xs text-slate-500 truncate max-w-xs">{{ $acc->description }}</p>
                                    </td>
                                    <td class="px-6 py-3 text-right">
                                        <div class="flex items-center justify-end gap-3 opacity-0 group-hover:opacity-100 transition">
                                            <button @click="editModal = true; editData = { id: {{ $acc->id }}, name: '{{ $acc->name }}', code: '{{ $acc->code }}', description: '{{ $acc->description }}', type: '{{ $acc->type }}' }"
                                                class="text-indigo-600 hover:text-indigo-800 font-bold text-xs flex items-center gap-1">
                                                <i class="ph-bold ph-pencil-simple"></i> Edit
                                            </button>

                                            <form action="{{ route('admin.accounts.destroy', $acc->id) }}" method="POST" onsubmit="return confirm('Delete {{ $acc->name }}? This cannot be undone.');">
                                                @csrf @method('DELETE')
                                                <button type="submit" class="text-red-500 hover:text-red-700 font-bold text-xs flex items-center gap-1">
                                                    <i class="ph-bold ph-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @endif
                @endforeach

                @if($accounts->isEmpty())
                    <div class="text-center py-12 bg-white rounded-2xl shadow-sm border border-dashed border-slate-300">
                        <i class="ph-duotone ph-books text-4xl text-slate-300 mb-2"></i>
                        <p class="text-slate-500">No accounts found. Create one to get started.</p>
                    </div>
                @endif
            </div>

        </div>

        <div x-show="editModal" style="display: none;" class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div x-show="editModal" @click="editModal = false" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="fixed inset-0 bg-slate-900 bg-opacity-75 transition-opacity" aria-hidden="true"></div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div x-show="editModal" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">

                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-indigo-100 sm:mx-0 sm:h-10 sm:w-10">
                                <i class="ph-bold ph-pencil-simple text-indigo-600"></i>
                            </div>
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                                <h3 class="text-lg leading-6 font-medium text-slate-900" id="modal-title">Edit Account</h3>
                                <div class="mt-4">
                                    <form :action="`{{ url('finance/accounts') }}/${editData.id}`" method="POST" id="editForm">
                                        @csrf
                                        @method('PUT')
                                        <div class="space-y-4">
                                            <div>
                                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Account Name</label>
                                                <input type="text" name="name" x-model="editData.name" class="w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                            </div>
                                            <div>
                                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Type</label>
                                                <select name="type" x-model="editData.type" class="w-full rounded-md border-slate-300 shadow-sm sm:text-sm bg-slate-50 cursor-not-allowed" readonly>
                                                    <option value="income">Income</option>
                                                    <option value="expense">Expense</option>
                                                    <option value="liability">Liability</option>
                                                    <option value="asset">Asset</option>
                                                    <option value="equity">Equity</option>
                                                </select>
                                                <p class="text-[10px] text-red-400 mt-1">Type cannot be changed to ensure data integrity.</p>
                                            </div>
                                            <div>
                                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1">GL Code</label>
                                                <input type="text" name="code" x-model="editData.code" class="w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                            </div>
                                            <div>
                                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Description</label>
                                                <textarea name="description" x-model="editData.description" rows="2" class="w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm"></textarea>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-slate-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="button" onclick="document.getElementById('editForm').submit()" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-indigo-600 text-base font-medium text-white hover:bg-indigo-700 focus:outline-none sm:ml-3 sm:w-auto sm:text-sm">
                            Save Changes
                        </button>
                        <button type="button" @click="editModal = false" class="mt-3 w-full inline-flex justify-center rounded-md border border-slate-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-slate-700 hover:bg-slate-50 focus:outline-none sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            Cancel
                        </button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</x-app-layout>
