<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">Edit Role: {{ $role->name }}</h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white shadow-sm sm:rounded-lg p-6">

                <form action="{{ route('admin.roles.update', $role->id) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="mb-6">
                        <label class="block text-gray-700 font-bold mb-2">Role Name</label>
                        <input type="text" name="name" value="{{ $role->name }}" class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500" required>
                    </div>

                    <div class="mb-6">
                        <label class="block text-gray-700 font-bold mb-4">Assign Permissions</label>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            @foreach($permissions as $permission)
                            <div class="flex items-center">
                                <input type="checkbox" name="permissions[]" value="{{ $permission->name }}"
                                       id="perm_{{ $permission->id }}"
                                       class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500"
                                       {{ in_array($permission->id, $rolePermissions) ? 'checked' : '' }}>
                                <label for="perm_{{ $permission->id }}" class="ml-2 text-sm text-gray-600 cursor-pointer">
                                    {{ $permission->name }}
                                </label>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded hover:bg-indigo-700">Update Role</button>
                </form>

            </div>
        </div>
    </div>
</x-app-layout>
