<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Roles & Staff Assignments') }}
            </h2>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">

            <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-6" x-data="{ open: false }">
                <div class="flex justify-between items-center">
                    <div>
                        <h3 class="text-lg font-bold text-slate-800">System Roles</h3>
                        <p class="text-sm text-slate-500">Manage access levels and assign staff.</p>
                    </div>
                    <button @click="open = !open"
                        class="bg-slate-900 text-white px-4 py-2 rounded-lg text-sm font-bold hover:bg-slate-700 transition flex items-center gap-2">
                        <i class="ph-bold ph-plus-circle"></i> Create New Role
                    </button>
                </div>

                <div x-show="open" x-transition class="mt-6 pt-6 border-t border-slate-100">
                    <form action="{{ route('admin.roles.store') }}" method="POST" class="flex items-end gap-4 bg-slate-50 p-4 rounded-lg border border-slate-200">
                        @csrf
                        <div class="flex-1">
                            <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Role Name</label>
                            <input type="text" name="name" placeholder="e.g. Paralegal"
                                class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" required>
                        </div>
                        <button type="submit" class="bg-indigo-600 text-white px-6 py-2.5 rounded-md text-sm font-bold hover:bg-indigo-700 shadow-sm">
                            Save Role
                        </button>
                    </form>
                </div>
            </div>

            @foreach ($roles as $role)
                <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl overflow-hidden"
                    x-data="{ showAddUser: false }">

                    <div class="px-6 py-4 bg-slate-50 border-b border-slate-100 flex justify-between items-center">
                        <div class="flex items-center gap-3">
                            <div class="h-10 w-10 rounded-lg bg-indigo-600 flex items-center justify-center text-white">
                                @if ($role->name == 'super_admin')
                                    <i class="ph-bold ph-crown text-xl"></i>
                                @elseif($role->name == 'lawyer')
                                    <i class="ph-bold ph-briefcase text-xl"></i>
                                @elseif($role->name == 'client')
                                    <i class="ph-bold ph-user text-xl"></i>
                                @else
                                    <i class="ph-bold ph-shield text-xl"></i>
                                @endif
                            </div>
                            <div>
                                <h3 class="text-lg font-bold text-slate-800 capitalize">
                                    {{ str_replace('_', ' ', $role->name) }}</h3>
                                <p class="text-xs text-slate-500 font-medium uppercase tracking-wide">
                                    {{ $role->users->count() }} Active Staff</p>
                            </div>
                        </div>

                        <div class="flex items-center gap-3">
                             @if(!in_array($role->name, ['super_admin', 'lawyer', 'client']))
                                <form action="{{ route('admin.roles.destroy', $role->id) }}" method="POST" onsubmit="return confirm('Delete this role? Users will lose these permissions.');">
                                    @csrf @method('DELETE')
                                    <button type="submit" class="text-slate-400 hover:text-red-600 transition p-2">
                                        <i class="ph-bold ph-trash text-lg"></i>
                                    </button>
                                </form>
                            @endif

                            <button @click="showAddUser = !showAddUser"
                                class="text-indigo-600 hover:text-indigo-800 text-sm font-bold flex items-center gap-1 transition bg-indigo-50 px-3 py-1.5 rounded-lg border border-indigo-100">
                                <span x-text="showAddUser ? 'Cancel' : '+ Assign Staff'"></span>
                            </button>
                        </div>
                    </div>

                    <div x-show="showAddUser" x-transition class="bg-indigo-50 px-6 py-4 border-b border-indigo-100">
                        <form action="{{ route('admin.roles.assign', $role->id) }}" method="POST"
                            class="flex items-end gap-4">
                            @csrf
                            <div class="flex-1">
                                <label class="block text-xs font-bold text-indigo-900 uppercase mb-1">Select User to
                                    Assign</label>
                                <select name="user_id"
                                    class="block w-full rounded-md border-indigo-200 text-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="">-- Choose User --</option>
                                    @foreach ($users as $user)
                                        @unless ($user->hasRole($role->name))
                                            <option value="{{ $user->id }}">{{ $user->name }} ({{ $user->email }})
                                            </option>
                                        @endunless
                                    @endforeach
                                </select>
                            </div>
                            <button type="submit"
                                class="bg-indigo-600 text-white px-4 py-2 rounded-md text-sm font-bold hover:bg-indigo-700 shadow-sm">
                                Add to Role
                            </button>
                        </form>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 divide-y md:divide-y-0 md:divide-x divide-slate-100">

                        <div class="p-6">
                            <h4 class="text-xs font-bold text-slate-400 uppercase tracking-wider mb-4">Assigned Staff
                            </h4>

                            @if ($role->users->count() > 0)
                                <ul class="space-y-3">
                                    @foreach ($role->users as $assignedUser)
                                        <li class="flex justify-between items-center group">
                                            <div class="flex items-center gap-3">
                                                <div
                                                    class="h-8 w-8 rounded-full bg-slate-200 flex items-center justify-center text-xs font-bold text-slate-600">
                                                    {{ substr($assignedUser->name, 0, 1) }}
                                                </div>
                                                <div>
                                                    <p class="text-sm font-bold text-slate-700">
                                                        {{ $assignedUser->name }}</p>
                                                    <p class="text-xs text-slate-400">{{ $assignedUser->email }}</p>
                                                </div>
                                            </div>

                                            @if ($assignedUser->id !== auth()->id() || $role->name == 'super_admin')
                                                <form
                                                    action="{{ route('admin.roles.remove', [$role->id, $assignedUser->id]) }}"
                                                    method="POST"
                                                    onsubmit="return confirm('Remove role from this user?');">
                                                    @csrf
                                                    @method('DELETE')

                                                    <button type="submit"
                                                        class="text-slate-300 hover:text-red-500 transition group-hover:opacity-100"
                                                        title="Remove User">
                                                        <i class="ph-bold ph-x-circle text-lg"></i>
                                                    </button>
                                                </form>
                                            @else
                                                <span class="text-xs text-slate-300 italic">It's you</span>
                                            @endif
                                        </li>
                                    @endforeach
                                </ul>
                            @else
                                <p class="text-sm text-slate-400 italic">No users assigned to this role yet.</p>
                            @endif
                        </div>

                        <div class="p-6 bg-slate-50/50">
                            <h4 class="text-xs font-bold text-slate-400 uppercase tracking-wider mb-4">Permissions
                                ({{ $role->permissions->count() }})</h4>
                            <div class="flex flex-wrap gap-2">
                                @forelse($role->permissions as $perm)
                                    <span
                                        class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-white border border-slate-200 text-slate-600 shadow-sm">
                                        {{ $perm->name }}
                                    </span>
                                @empty
                                    <span class="text-sm text-slate-400 italic">No specific permissions set.</span>
                                @endforelse
                            </div>
                            <div class="mt-4 pt-4 border-t border-slate-200">
                                <a href="{{ route('admin.roles.edit', $role->id) }}"
                                    class="text-xs font-bold text-indigo-600 hover:text-indigo-800 flex items-center gap-1">
                                    <i class="ph-bold ph-pencil-simple"></i> Manage Permissions
                                </a>
                            </div>
                        </div>

                    </div>
                </div>
            @endforeach

        </div>
    </div>
</x-app-layout>
