<x-guest-layout>
    <div class="relative">
        <div class="text-center mb-10">
            <div class="relative inline-flex items-center justify-center w-20 h-20 rounded-3xl bg-indigo-600 text-white shadow-2xl shadow-indigo-200 mb-6 group overflow-hidden">
                <div class="absolute inset-0 bg-white/20 group-hover:scale-150 transition-transform duration-700 rounded-full"></div>
                <i class="ph-bold ph-scales text-4xl relative z-10"></i>
            </div>

            <h2 class="text-3xl font-black text-slate-900 tracking-tight">
                Legal<span class="text-indigo-600">Pro</span>
            </h2>
            <div class="flex items-center justify-center gap-2 mt-2">
                <span class="h-px w-4 bg-slate-200"></span>
                <p class="text-slate-500 text-[10px] font-bold uppercase tracking-[0.2em]">Secure Practice Portal</p>
                <span class="h-px w-4 bg-slate-200"></span>
            </div>
        </div>

        <x-auth-session-status class="mb-6" :status="session('status')" />

        <form method="POST" action="{{ route('login') }}" class="space-y-5">
            @csrf

            <div>
                <label for="email" class="block text-[11px] font-extrabold text-slate-400 uppercase tracking-widest mb-2 px-1">Firm Credentials</label>
                <div class="relative group">
                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-slate-400 group-focus-within:text-indigo-600 transition-colors">
                        <i class="ph-bold ph-envelope-simple text-xl"></i>
                    </div>
                    <input id="email"
                           class="block w-full pl-12 pr-4 py-3.5 bg-slate-50 border border-slate-200 rounded-2xl text-slate-900 placeholder-slate-400 focus:outline-none focus:bg-white focus:ring-4 focus:ring-indigo-500/10 focus:border-indigo-500 transition-all sm:text-sm font-semibold"
                           type="email" name="email" :value="old('email')" required autofocus autocomplete="username" placeholder="attorney@firm.com" />
                </div>
                <x-input-error :messages="$errors->get('email')" class="mt-2" />
            </div>

            <div>
                <div class="flex items-center justify-between mb-2 px-1">
                    <label for="password" class="block text-[11px] font-extrabold text-slate-400 uppercase tracking-widest">Master Password</label>
                </div>
                <div class="relative group">
                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-slate-400 group-focus-within:text-indigo-600 transition-colors">
                        <i class="ph-bold ph-fingerprint text-xl"></i>
                    </div>
                    <input id="password"
                           class="block w-full pl-12 pr-4 py-3.5 bg-slate-50 border border-slate-200 rounded-2xl text-slate-900 placeholder-slate-400 focus:outline-none focus:bg-white focus:ring-4 focus:ring-indigo-500/10 focus:border-indigo-500 transition-all sm:text-sm font-semibold"
                           type="password" name="password" required autocomplete="current-password" placeholder="••••••••" />
                </div>
                <x-input-error :messages="$errors->get('password')" class="mt-2" />
            </div>

            <div class="flex items-center justify-between py-2">
                <label for="remember_me" class="inline-flex items-center cursor-pointer group">
                    <div class="relative flex items-center">
                        <input id="remember_me" type="checkbox" class="rounded-md border-slate-300 text-indigo-600 shadow-sm focus:ring-indigo-500 cursor-pointer h-5 w-5" name="remember">
                    </div>
                    <span class="ml-3 text-sm font-bold text-slate-500 group-hover:text-slate-800 transition-colors">{{ __('Stay logged in') }}</span>
                </label>

                @if (Route::has('password.request'))
                    <a class="text-xs font-bold text-indigo-600 hover:text-indigo-800 transition-colors underline decoration-indigo-200 underline-offset-4" href="{{ route('password.request') }}">
                        {{ __('Forgot access?') }}
                    </a>
                @endif
            </div>

            <button type="submit" class="w-full flex justify-center items-center gap-2 py-4 px-4 border border-transparent rounded-2xl shadow-xl shadow-indigo-100 text-sm font-black text-white bg-slate-900 hover:bg-indigo-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-slate-900 transition-all transform hover:-translate-y-1 active:scale-[0.98]">
                Unlock Secure Vault <i class="ph-bold ph-arrow-right"></i>
            </button>
        </form>

        <div class="mt-10 pt-8 border-t border-slate-100">
            <div class="bg-indigo-50/50 rounded-2xl p-4 flex items-center justify-between">
                <div>
                    <p class="text-[10px] font-bold text-indigo-900 uppercase tracking-tighter">New Account?</p>
                    <p class="text-xs text-indigo-600/80">Join the practice today.</p>
                </div>
                <a href="{{ route('register') }}" class="px-4 py-2 bg-white border border-indigo-100 rounded-xl text-xs font-bold text-indigo-600 hover:bg-indigo-600 hover:text-white transition shadow-sm">
                    Register
                </a>
            </div>
        </div>

        <div class="mt-6 flex justify-center items-center gap-4 opacity-40 grayscale">
            <i class="ph ph-shield-check text-2xl"></i>
            <span class="text-[10px] font-bold uppercase tracking-widest text-slate-500">256-bit AES Encryption</span>
        </div>
    </div>
</x-guest-layout>
