<x-guest-layout>
    <form method="POST" action="{{ route('register.firm') }}">
        @csrf

        <div>
            <x-input-label for="firm_name" :value="__('Law Firm Name')" />
            <x-text-input id="firm_name" class="block mt-1 w-full" type="text" name="firm_name" required autofocus />
        </div>

        <div class="mt-4">
            <x-input-label for="subdomain" :value="__('Workspace URL')" />
            <div class="flex items-center">
                <x-text-input id="subdomain" class="block mt-1 w-full rounded-r-none border-r-0" type="text" name="subdomain" required />
                <span class="inline-flex items-center px-3 py-2 text-sm text-gray-900 bg-gray-200 border border-l-0 border-gray-300 rounded-r-md mt-1 h-[42px]">
                    .{{ config('tenancy.central_domains')[0] }}
                </span>
            </div>
        </div>

        <div class="mt-4">
            <x-input-label for="name" :value="__('Admin Name')" />
            <x-text-input id="name" class="block mt-1 w-full" type="text" name="name" required />
        </div>

        <div class="mt-4">
            <x-input-label for="email" :value="__('Email')" />
            <x-text-input id="email" class="block mt-1 w-full" type="email" name="email" required />
        </div>

        <div class="mt-4">
            <x-input-label for="password" :value="__('Password')" />
            <x-text-input id="password" class="block mt-1 w-full" type="password" name="password" required />
        </div>

        <div class="mt-4">
            <x-input-label for="password_confirmation" :value="__('Confirm Password')" />
            <x-text-input id="password_confirmation" class="block mt-1 w-full" type="password" name="password_confirmation" required />
        </div>

        <div class="flex items-center justify-end mt-4">
            <x-primary-button class="ml-4">
                {{ __('Launch Workspace') }}
            </x-primary-button>
        </div>
    </form>
</x-guest-layout>
