@props(['active', 'icon'])

@php
$classes = ($active ?? false)
            ? 'flex items-center gap-3 px-4 py-3 text-sm font-bold bg-indigo-600 text-white rounded-xl shadow-lg shadow-indigo-600/20 transition group'
            : 'flex items-center gap-3 px-4 py-3 text-sm font-bold text-slate-400 hover:bg-slate-800 hover:text-white rounded-xl transition group';

$iconClass = ($active ?? false)
            ? 'text-white text-lg'
            : 'text-slate-500 group-hover:text-white text-lg transition-colors';
@endphp

<a {{ $attributes->merge(['class' => $classes]) }}>
    <i class="{{ $icon }} ph-bold {{ $iconClass }}"></i>
    <span>{{ $slot }}</span>
</a>
