

<x-admin-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-slate-800 flex items-center gap-2">
                <i class="ph-duotone ph-shield-check text-indigo-600"></i>
                {{ __('SaaS Command Center') }}
            </h2>
            <a href="{{ route('admin.tenants.create') }}"
                class="bg-indigo-600 text-white px-4 py-2 rounded-xl text-sm font-bold shadow-lg shadow-indigo-200 hover:bg-indigo-700 transition">
                + Provision New Firm
            </a>
        </div>
    </x-slot>

    <div class="py-10 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-8">

            <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                <div class="bg-white p-6 rounded-2xl shadow-sm border border-slate-100">
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Total Firms</p>
                    <h3 class="text-3xl font-black text-slate-800 mt-2">{{ $stats['total_firms'] }}</h3>
                </div>
                <div class="bg-white p-6 rounded-2xl shadow-sm border border-slate-100">
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Active Subscriptions</p>
                    <h3 class="text-3xl font-black text-emerald-600 mt-2">{{ $stats['active_firms'] }}</h3>
                </div>
                <div class="bg-white p-6 rounded-2xl shadow-sm border border-slate-100">
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Monthly Growth</p>
                    <h3 class="text-3xl font-black text-indigo-600 mt-2">+{{ $stats['new_this_month'] }}</h3>
                </div>
                <div class="bg-white p-6 rounded-2xl shadow-sm border border-slate-100">
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest">System Health</p>
                    <div class="flex items-center gap-2 mt-2">
                        <span class="h-3 w-3 rounded-full bg-emerald-500 animate-pulse"></span>
                        <span class="font-bold text-slate-700">All Systems Nominal</span>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-50">
                    <h4 class="font-bold text-slate-800">Managed Law Firms</h4>
                </div>
                <table class="min-w-full text-left text-sm">
                    <thead class="bg-slate-50 text-slate-500 font-bold uppercase text-[10px] tracking-widest">
                        <tr>
                            <th class="px-6 py-4">Law Firm / Tenant ID</th>
                            <th class="px-6 py-4">Access URL</th>
                            <th class="px-6 py-4">Plan</th>
                            <th class="px-6 py-4">Status</th>
                            <th class="px-6 py-4 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100">
                        @foreach ($tenants as $tenant)
                            <tr class="hover:bg-slate-50/50 transition">
                                <td class="px-6 py-4">
                                    <div class="font-bold text-slate-800">{{ $tenant->firm_name }}</div>
                                    <div class="text-xs text-slate-400 font-mono">{{ $tenant->id }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    @foreach ($tenant->domains as $domain)
                                        <a href="http://{{ $domain->domain }}" target="_blank"
                                            class="text-indigo-600 hover:underline flex items-center gap-1">
                                            {{ $domain->domain }} <i class="ph ph-arrow-square-out"></i>
                                        </a>
                                    @endforeach
                                </td>
                                <td class="px-6 py-4">
                                    <span
                                        class="px-2 py-1 bg-slate-100 rounded text-[10px] font-bold uppercase text-slate-600">
                                        {{ $tenant->plan ?? 'Premium' }}
                                    </span>
                                </td>
                                <td class="px-6 py-4">
                                    <span
                                        class="px-2 py-1 {{ $tenant->subscription_status == 'active' ? 'bg-emerald-100 text-emerald-700' : 'bg-rose-100 text-rose-700' }} rounded-full text-[10px] font-bold uppercase">
                                        {{ $tenant->subscription_status }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <button class="text-slate-400 hover:text-indigo-600"><i
                                            class="ph-bold ph-dots-three-outline"></i></button>




                                    <a href="{{ route('landlord.tenants.show', $tenant->id) }}"
                                        class="text-slate-400 hover:text-indigo-600">
                                        <i class="ph-bold ph-caret-right"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="p-4 bg-slate-50 border-t border-slate-100">
                    {{ $tenants->links() }}
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
