<x-admin-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-gray-900">
                Manage Firm: {{ $tenant->firm_name }}
            </h2>
            <div class="flex gap-3">
                <a href="{{ route('landlord.tenants.impersonate', $tenant->id) }}"
                   class="bg-gray-800 hover:bg-gray-900 text-white font-bold py-2 px-4 rounded-lg flex items-center gap-2">
                   <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                   Login as Admin
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12 bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

                <div class="md:col-span-1 space-y-6">
                    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                        <h3 class="text-xs font-bold text-gray-400 uppercase tracking-wider mb-4">Firm Overview</h3>

                        <div class="space-y-4">
                            <div>
                                <span class="text-sm text-gray-500 block">Domain</span>
                                <a href="http://{{ $tenant->domains->first()->domain }}" target="_blank" class="text-indigo-600 font-medium hover:underline">
                                    {{ $tenant->domains->first()->domain }} ↗
                                </a>
                            </div>

                            <div>
                                <span class="text-sm text-gray-500 block">Status</span>
                                @if($tenant->subscription_status === 'active')
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        Active
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                        Suspended
                                    </span>
                                @endif
                            </div>

                            <div>
                                <span class="text-sm text-gray-500 block">Database ID</span>
                                <code class="text-xs bg-gray-100 px-2 py-1 rounded text-gray-600">{{ $tenant->tenancy_db_name }}</code>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="md:col-span-2">
                    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-50 bg-gray-50/50">
                            <h3 class="text-lg font-semibold text-gray-900">Edit Configuration</h3>
                            <p class="text-sm text-gray-500">Update firm details and assign admin roles.</p>
                        </div>

                        <form action="{{ route('landlord.tenants.update', $tenant->id) }}" method="POST" class="p-8 space-y-6">
                            @csrf

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Firm Name</label>
                                    <input type="text" name="firm_name" value="{{ $tenant->firm_name }}" class="w-full rounded-lg border-gray-300 focus:ring-indigo-500 focus:border-indigo-500">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Plan</label>
                                    <select name="plan" class="w-full rounded-lg border-gray-300 focus:ring-indigo-500 focus:border-indigo-500">
                                        <option value="free" {{ $tenant->plan == 'free' ? 'selected' : '' }}>Free Trial</option>
                                        <option value="premium" {{ $tenant->plan == 'premium' ? 'selected' : '' }}>Premium</option>
                                        <option value="enterprise" {{ $tenant->plan == 'enterprise' ? 'selected' : '' }}>Enterprise</option>
                                    </select>
                                </div>
                            </div>

                            <hr class="border-gray-100">

                            <div>
                                <h4 class="text-sm font-bold text-gray-900 mb-4 flex items-center gap-2">
                                    <svg class="w-4 h-4 text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/></svg>
                                    Primary Administrator
                                </h4>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Admin Email</label>
                                        <input type="email" name="email" value="{{ $tenant->email }}" class="w-full rounded-lg border-gray-300 focus:ring-indigo-500 focus:border-indigo-500">
                                        <p class="text-xs text-gray-400 mt-1">This updates the login email inside the tenant DB.</p>
                                    </div>

                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Assigned Role</label>
                                        <select name="role" class="w-full rounded-lg border-gray-300 focus:ring-indigo-500 focus:border-indigo-500">
                                            @php
                                                $currentRole = $tenantAdmin ? $tenantAdmin->roles->pluck('name')->first() : '';
                                            @endphp
                                            <option value="super_admin" {{ $currentRole == 'super_admin' ? 'selected' : '' }}>Super Admin (Full Access)</option>
                                            <option value="lawyer" {{ $currentRole == 'lawyer' ? 'selected' : '' }}>Lawyer (Restricted)</option>
                                            <option value="clerk" {{ $currentRole == 'clerk' ? 'selected' : '' }}>Clerk (ReadOnly)</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="flex justify-end pt-4">
                                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3 px-8 rounded-xl shadow-lg transition transform hover:-translate-y-0.5">
                                    Save Changes
                                </button>
                            </div>

                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>
</x-admin-layout>
