<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'LegalPro') }}</title>

    <!-- App Logo / Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('assets/images/logo.png') }}">
    <link rel="apple-touch-icon" href="{{ asset('assets/images/logo.png') }}">

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
</head>


<body class="font-sans antialiased bg-slate-50 text-slate-900" x-data="{ sidebarOpen: false }">
    @if (session('is_impersonating'))
        <div
            class="bg-indigo-600 text-white py-2 px-4 flex justify-between items-center sticky top-0 z-[100] shadow-lg">
            <div class="flex items-center gap-2 text-sm font-bold">
                <i class="ph-fill ph-mask-happy"></i>
                <span>Impersonation Mode Active</span>
            </div>

            <form action="#" method="GET" class="m-0">
                {{-- <form action="{{ route('impersonate.exit') }}" method="POST" class="m-0"> --}}
                @csrf
                <button type="submit"
                    class="bg-white text-indigo-600 px-4 py-1 rounded-lg text-xs font-black uppercase hover:bg-slate-100 transition">
                    Exit & Return to Landlord
                </button>
            </form>
        </div>
    @endif
    <div class="flex h-screen overflow-hidden">

        <aside :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'"
            class="fixed inset-y-0 left-0 z-50 w-64 bg-slate-900 text-white transition-transform duration-300 ease-in-out lg:static lg:translate-x-0 flex flex-col shadow-2xl lg:shadow-none">

            <div
                class="flex items-center justify-center h-16 bg-slate-950 shadow-sm flex-shrink-0 border-b border-slate-800">
                <a href="{{ route('dashboard') }}"
                    class="flex items-center gap-2 text-xl font-bold tracking-wide text-white">
                    <i class="ph-fill ph-scales text-indigo-500 text-2xl"></i>
                    <span>LEGAL<span class="text-indigo-500">PRO</span></span>
                </a>
            </div>

            <nav class="mt-5 px-3 space-y-1 flex-1 overflow-y-auto custom-scrollbar">

                @role('client')
                    <div class="px-3 pt-4 pb-2 text-xs font-bold text-slate-500 uppercase tracking-wider">
                        Client Portal
                    </div>

                    <a href="{{ route('dashboard') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group
                        {{ request()->routeIs('dashboard') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-900/50' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-house-line text-lg mr-3 {{ request()->routeIs('admin.dashboard') ? 'text-white' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Overview
                    </a>
                @endrole

                @role('super_admin')
                    <a href="{{ route('admin.superadmin.dashboard') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group mb-6
                        {{ request()->routeIs('admin.superadmin.dashboard') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-900/50' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-chart-pie-slice text-lg mr-3 {{ request()->routeIs('admin.superadmin.dashboard') ? 'text-white' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Executive Dashboard
                    </a>
                @endrole

                @hasanyrole('client|lawyer|super_admin')
                    <a href="{{ route('client.chat.index') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group mb-6
                        {{ request()->routeIs('client.chat.index') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-900/50' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-chart-pie-slice text-lg mr-3 {{ request()->routeIs('client.chat.index') ? 'text-white' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Ai Chat
                    </a>
                @endhasanyrole




                @hasanyrole('lawyer|super_admin')
                    <div class="px-3 pt-2 pb-2 text-xs font-bold text-slate-500 uppercase tracking-wider">
                        Practice
                    </div>

                    <a href="{{ route('dashboard') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group
                        {{ request()->routeIs('dashboard') ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-squares-four text-lg mr-3 {{ request()->routeIs('admin.dashboard') ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Workspace
                    </a>

                    <a href="{{ route('admin.cases.index') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group
                        {{ request()->routeIs('admin.cases.*') ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-briefcase text-lg mr-3 {{ request()->routeIs('admin.cases.*') ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Legal Matters
                    </a>

                    <a href="{{ route('admin.clients.index') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group
                        {{ request()->routeIs('admin.clients.*') ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-users-three text-lg mr-3 {{ request()->routeIs('admin.clients.*') ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Clients Directory
                    </a>

                    <a href="{{ route('admin.documents.index') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group
                        {{ request()->routeIs('admin.documents.*') ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-files text-lg mr-3 {{ request()->routeIs('admin.documents.*') ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Documents
                    </a>

                    <div class="px-3 pt-6 pb-2 text-xs font-bold text-slate-500 uppercase tracking-wider">
                        Operations
                    </div>

                    <a href="{{ route('admin.appointments.index') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group
                        {{ request()->routeIs('admin.appointments.*') ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-calendar-check text-lg mr-3 {{ request()->routeIs('admin.appointments.*') ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Schedule
                    </a>

                    <a href="{{ route('admin.finance.index') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group
                        {{ request()->routeIs('admin.finance.*') ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-currency-dollar text-lg mr-3 {{ request()->routeIs('admin.finance.*') ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Finance & Billing
                    </a>
                @endhasanyrole

                @role('super_admin')
                    <div class="px-3 pt-6 pb-2 text-xs font-bold text-slate-500 uppercase tracking-wider">
                        Configuration
                    </div>

                    <a href="{{ route('admin.roles.index') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group
                        {{ request()->routeIs('admin.roles.*') ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-shield-check text-lg mr-3 {{ request()->routeIs('admin.roles.*') ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Roles & Staff
                    </a>

                    <a href="{{ route('admin.settings.index') }}"
                        class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 group
                        {{ request()->routeIs('admin.settings.*') ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                        <i
                            class="ph ph-sliders text-lg mr-3 {{ request()->routeIs('admin.settings.*') ? 'text-indigo-400' : 'text-slate-500 group-hover:text-white' }}"></i>
                        Global Settings
                    </a>
                @endrole

            </nav>

            <div class="bg-slate-950 border-t border-slate-800 p-4">
                <a href="{{ route('profile.edit') }}"
                    class="flex items-center gap-3 w-full p-2 rounded-lg hover:bg-slate-800 transition-colors group">
                    <div
                        class="h-10 w-10 rounded-full bg-gradient-to-br from-indigo-500 to-purple-600 flex items-center justify-center text-white font-bold text-sm shadow-md ring-2 ring-slate-800 group-hover:ring-indigo-500 transition">
                        {{ substr(Auth::user()->name, 0, 1) }}
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-medium text-white truncate group-hover:text-indigo-200 transition">
                            {{ Auth::user()->name }}
                        </p>
                        <p class="text-xs text-slate-500 truncate">
                            @if (auth()->user()->hasRole('super_admin'))
                                Super Admin
                            @elseif(auth()->user()->hasRole('lawyer'))
                                Attorney
                            @else
                                Client Account
                            @endif
                        </p>
                    </div>
                </a>
            </div>
        </aside>

        <div class="flex-1 flex flex-col overflow-hidden bg-slate-50">

            <header
                class="flex items-center justify-between h-16 bg-white px-6 shadow-sm border-b border-slate-200 z-10">
                <button @click="sidebarOpen = !sidebarOpen"
                    class="text-slate-500 focus:outline-none lg:hidden hover:text-indigo-600 transition">
                    <i class="ph ph-list text-2xl"></i>
                </button>

                <div class="ml-4 lg:ml-0 flex-1">
                    {{ $header ?? '' }}
                </div>

                <div class="flex items-center space-x-4">

                    @hasanyrole('lawyer|super_admin')
                        <button
                            class="relative p-2 text-slate-400 hover:text-indigo-600 transition rounded-full hover:bg-slate-50">
                            <span class="absolute top-2 right-2 h-2 w-2 rounded-full bg-red-500 border border-white"></span>
                            <i class="ph ph-bell text-xl"></i>
                        </button>
                    @endhasanyrole



                    <div class="h-6 w-px bg-slate-200 mx-2"></div>

                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" @click.away="open = false"
                            class="flex items-center gap-2 text-sm focus:outline-none group">
                            <span
                                class="text-slate-700 font-medium group-hover:text-indigo-600 transition hidden sm:block">{{ Auth::user()->name }}</span>
                            <i class="ph-bold ph-caret-down text-slate-400 group-hover:text-indigo-600 transition"></i>
                        </button>

                        <div x-show="open" style="display: none;" x-transition:enter="transition ease-out duration-100"
                            x-transition:enter-start="transform opacity-0 scale-95"
                            x-transition:enter-end="transform opacity-100 scale-100"
                            x-transition:leave="transition ease-in duration-75"
                            x-transition:leave-start="transform opacity-100 scale-100"
                            x-transition:leave-end="transform opacity-0 scale-95"
                            class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-xl py-1 ring-1 ring-black ring-opacity-5 z-50 origin-top-right border border-slate-100">

                            <div class="px-4 py-3 border-b border-slate-100 sm:hidden">
                                <p class="text-xs text-slate-500">Signed in as</p>
                                <p class="text-sm font-bold text-slate-800 truncate">{{ Auth::user()->email }}</p>
                            </div>

                            <a href="{{ route('profile.edit') }}"
                                class="flex items-center px-4 py-2.5 text-sm text-slate-600 hover:bg-slate-50 hover:text-indigo-600 transition">
                                <i class="ph-bold ph-user-circle mr-2 text-lg"></i> Your Profile
                            </a>

                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit"
                                    class="flex w-full items-center px-4 py-2.5 text-sm text-red-600 hover:bg-red-50 transition border-t border-slate-100">
                                    <i class="ph-bold ph-sign-out mr-2 text-lg"></i> Sign Out
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </header>

            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-slate-50 p-4 sm:p-6 lg:p-8">
                @if (session('success'))
                    <div class="mb-6 bg-emerald-50 border-l-4 border-emerald-500 p-4 rounded-r-lg shadow-sm flex items-start gap-3"
                        x-data="{ show: true }" x-show="show">
                        <i class="ph-fill ph-check-circle text-emerald-500 text-xl mt-0.5"></i>
                        <div class="flex-1">
                            <p class="text-sm font-bold text-emerald-800">Success</p>
                            <p class="text-sm text-emerald-700">{{ session('success') }}</p>
                        </div>
                        <button @click="show = false" class="text-emerald-400 hover:text-emerald-600"><i
                                class="ph-bold ph-x"></i></button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg shadow-sm flex items-start gap-3"
                        x-data="{ show: true }" x-show="show">
                        <i class="ph-fill ph-warning-circle text-red-500 text-xl mt-0.5"></i>
                        <div class="flex-1">
                            <p class="text-sm font-bold text-red-800">Error</p>
                            <p class="text-sm text-red-700">{{ session('error') }}</p>
                        </div>
                        <button @click="show = false" class="text-red-400 hover:text-red-600"><i
                                class="ph-bold ph-x"></i></button>
                    </div>
                @endif

                {{ $slot }}
            </main>
        </div>

        <div x-show="sidebarOpen" @click="sidebarOpen = false"
            x-transition:enter="transition-opacity ease-linear duration-300" x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100" x-transition:leave="transition-opacity ease-linear duration-300"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            class="fixed inset-0 z-40 bg-slate-900/50 backdrop-blur-sm lg:hidden">
        </div>
    </div>
</body>

</html>
