<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-xl text-slate-800 leading-tight flex items-center gap-2">
            <i class="ph-duotone ph-user-gear text-indigo-600"></i>
            {{ __('Account Settings') }}
        </h2>
    </x-slot>

    <div class="py-12 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                <div class="lg:col-span-1 space-y-6">
                    <div class="bg-white p-6 shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl text-center relative overflow-hidden">
                        <div class="absolute top-0 left-0 w-full h-24 bg-gradient-to-r from-slate-800 to-indigo-900"></div>

                        <div class="relative mt-12 mb-4">
                            <div class="inline-flex items-center justify-center w-24 h-24 rounded-full bg-white p-1 shadow-lg">
                                <div class="w-full h-full rounded-full bg-indigo-600 flex items-center justify-center text-3xl font-bold text-white uppercase">
                                    {{ substr($user->name, 0, 1) }}
                                </div>
                            </div>
                        </div>

                        <h3 class="text-xl font-bold text-slate-900">{{ $user->name }}</h3>
                        <p class="text-sm text-slate-500 font-medium">{{ $user->email }}</p>

                        <div class="mt-6 border-t border-slate-100 pt-6 grid grid-cols-2 gap-4">
                            <div class="text-center">
                                <span class="block text-xl font-bold text-slate-800">{{ $user->created_at->format('M Y') }}</span>
                                <span class="text-xs text-slate-400 uppercase tracking-wider font-bold">Member Since</span>
                            </div>
                            <div class="text-center border-l border-slate-100">
                                <span class="block text-xl font-bold text-indigo-600">Active</span>
                                <span class="text-xs text-slate-400 uppercase tracking-wider font-bold">Status</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="lg:col-span-2 space-y-6">

                    <div class="p-4 sm:p-8 bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl">
                        @include('profile.partials.update-profile-information-form')
                    </div>

                    <div class="p-4 sm:p-8 bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl">
                        @include('profile.partials.update-password-form')
                    </div>

                    <div class="p-4 sm:p-8 bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl">
                        @include('profile.partials.delete-user-form')
                    </div>
                </div>

            </div>
        </div>
    </div>
</x-app-layout>
