<section>
    <header class="mb-6">
        <h2 class="text-lg font-bold text-slate-900 flex items-center gap-2">
            <i class="ph-duotone ph-lock-key text-indigo-500 text-xl"></i>
            {{ __('Update Password') }}
        </h2>
        <p class="mt-1 text-sm text-slate-500">
            {{ __('Ensure your account is using a long, random password to stay secure.') }}
        </p>
    </header>

    <form method="post" action="{{ route('password.update') }}" class="space-y-6">
        @csrf
        @method('put')

        <div>
            <x-input-label for="current_password" :value="__('Current Password')" class="text-xs font-bold uppercase text-slate-500 tracking-wider mb-1" />
            <input id="current_password" name="current_password" type="password" class="block w-full rounded-lg border-slate-300 bg-slate-50 focus:bg-white focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm transition-colors py-2.5" autocomplete="current-password" />
            <x-input-error :messages="$errors->updatePassword->get('current_password')" class="mt-2" />
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <x-input-label for="password" :value="__('New Password')" class="text-xs font-bold uppercase text-slate-500 tracking-wider mb-1" />
                <input id="password" name="password" type="password" class="block w-full rounded-lg border-slate-300 bg-slate-50 focus:bg-white focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm transition-colors py-2.5" autocomplete="new-password" />
                <x-input-error :messages="$errors->updatePassword->get('password')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="password_confirmation" :value="__('Confirm Password')" class="text-xs font-bold uppercase text-slate-500 tracking-wider mb-1" />
                <input id="password_confirmation" name="password_confirmation" type="password" class="block w-full rounded-lg border-slate-300 bg-slate-50 focus:bg-white focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm transition-colors py-2.5" autocomplete="new-password" />
                <x-input-error :messages="$errors->updatePassword->get('password_confirmation')" class="mt-2" />
            </div>
        </div>

        <div class="flex items-center gap-4 border-t border-slate-100 pt-6">
            <button type="submit" class="bg-slate-800 text-white px-6 py-2.5 rounded-lg text-sm font-bold hover:bg-slate-700 transition shadow-sm">
                Update Password
            </button>

            @if (session('status') === 'password-updated')
                <p x-data="{ show: true }" x-show="show" x-transition x-init="setTimeout(() => show = false, 2000)" class="text-sm text-green-600 font-bold flex items-center gap-1">
                    <i class="ph-bold ph-check"></i> {{ __('Saved.') }}
                </p>
            @endif
        </div>
    </form>
</section>
