<section>
    <header class="mb-6">
        <h2 class="text-lg font-bold text-slate-900 flex items-center gap-2">
            <i class="ph-duotone ph-identification-card text-indigo-500 text-xl"></i>
            {{ __('Profile Information') }}
        </h2>
        <p class="mt-1 text-sm text-slate-500">
            {{ __("Update your account's profile information and email address.") }}
        </p>
    </header>

    <form id="send-verification" method="post" action="{{ route('verification.send') }}">
        @csrf
    </form>

    <form method="post" action="{{ route('profile.update') }}" class="space-y-6">
        @csrf
        @method('patch')

        <div class="grid grid-cols-1 gap-6">
            <div>
                <x-input-label for="name" :value="__('Full Name')" class="text-xs font-bold uppercase text-slate-500 tracking-wider mb-1" />
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-slate-400">
                        <i class="ph-bold ph-user"></i>
                    </div>
                    <input id="name" name="name" type="text" class="block w-full pl-10 rounded-lg border-slate-300 bg-slate-50 focus:bg-white focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm transition-colors py-2.5"
                           value="{{ old('name', $user->name) }}" required autofocus autocomplete="name" />
                </div>
                <x-input-error class="mt-2" :messages="$errors->get('name')" />
            </div>

            <div>
                <x-input-label for="email" :value="__('Email Address')" class="text-xs font-bold uppercase text-slate-500 tracking-wider mb-1" />
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-slate-400">
                        <i class="ph-bold ph-envelope-simple"></i>
                    </div>
                    <input id="email" name="email" type="email" class="block w-full pl-10 rounded-lg border-slate-300 bg-slate-50 focus:bg-white focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm transition-colors py-2.5"
                           value="{{ old('email', $user->email) }}" required autocomplete="username" />
                </div>
                <x-input-error class="mt-2" :messages="$errors->get('email')" />

                @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail())
                    <div class="mt-4 p-4 bg-amber-50 border border-amber-200 rounded-lg flex items-start gap-3">
                        <i class="ph-fill ph-warning-circle text-amber-500 text-xl mt-0.5"></i>
                        <div>
                            <p class="text-sm text-amber-800 font-medium">
                                {{ __('Your email address is unverified.') }}
                            </p>
                            <button form="send-verification" class="text-sm underline text-amber-600 hover:text-amber-900 font-bold mt-1">
                                {{ __('Click here to re-send the verification email.') }}
                            </button>
                        </div>
                    </div>

                    @if (session('status') === 'verification-link-sent')
                        <p class="mt-2 font-medium text-sm text-green-600 flex items-center gap-2">
                            <i class="ph-bold ph-check-circle"></i>
                            {{ __('A new verification link has been sent to your email address.') }}
                        </p>
                    @endif
                @endif
            </div>
        </div>

        <div class="flex items-center gap-4 border-t border-slate-100 pt-6">
            <button type="submit" class="bg-indigo-600 text-white px-6 py-2.5 rounded-lg text-sm font-bold hover:bg-indigo-700 transition shadow-sm flex items-center gap-2">
                <i class="ph-bold ph-floppy-disk"></i> Save Changes
            </button>

            @if (session('status') === 'profile-updated')
                <p
                    x-data="{ show: true }"
                    x-show="show"
                    x-transition
                    x-init="setTimeout(() => show = false, 2000)"
                    class="text-sm text-green-600 font-bold flex items-center gap-1"
                >
                    <i class="ph-bold ph-check"></i> {{ __('Saved.') }}
                </p>
            @endif
        </div>
    </form>
</section>
