<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\TenantRegisterController;
use App\Http\Controllers\SuperAdmin\AdminController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\SuperAdmin\LandlordController;

use App\Http\Controllers\Tenant\ImpersonationController;
use App\Http\Controllers\SuperAdmin\TenantController;
use App\Http\Controllers\SuperAdmin\Landlord\SettingsController;

/*
|--------------------------------------------------------------------------
| Central (Landlord) Routes
|--------------------------------------------------------------------------
| These routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group.
|
*/

// 1. Landing Page
Route::get('/', function () {
    // If a user is logged in on the MAIN domain, they are a SaaS Admin
    if (Auth::check()) {
        return redirect()->route('dashboard');
    }
    return view('welcome');
});

// 2. Profile Management
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// 3. Tenant Registration (Public)
Route::middleware('guest')->group(function () {
    Route::get('/register-firm', [TenantRegisterController::class, 'showRegistrationForm'])
        ->name('register.firm');

    Route::post('/register-firm', [TenantRegisterController::class, 'register']);
});

Route::middleware(['auth'])->group(function () {
    // This dashboard is for YOU, the SaaS owner

    //  Route::post('/exit-impersonation', [ImpersonationController::class, 'exit'])
    //     ->name('impersonate.exit');

    Route::middleware(['auth',])->prefix('admin')->name('admin.')->group(function () {

        Route::resource('tenants', TenantController::class);
    });


    Route::get('/dashboard', [LandlordController::class, 'index'])->name('dashboard');

    // Other landlord features (Billing, etc.)
    Route::get('/firms/{tenant}', [LandlordController::class, 'show'])->name('landlord.tenants.show');
    Route::get('edit/firms/{tenant}', [LandlordController::class, 'edit'])->name('landlord.tenants.edit');
    Route::post('update/firms/{tenant}', [LandlordController::class, 'update'])->name('landlord.tenants.update');
    Route::post('tenants/{tenant}/toggle-status', [TenantController::class, 'toggleStatus'])
        ->name('landlord.tenants.toggle-status');

    Route::get('/settings', [SettingsController::class, 'index'])->name('admin.settings.index');
    Route::post('/settings', [SettingsController::class, 'update'])->name('admin.settings.update');
    Route::get('/impersonate/verify/{user}', function (Request $request, $user) {
        // 1. Check if the signature is valid and hasn't expired
        if (! $request->hasValidSignature()) {
            abort(403, 'Invalid or expired impersonation token.');
        }

        // 2. Log in the user
        Auth::loginUsingId($user);

        // 3. Mark the session so we can show a "Leave Impersonation" bar
        session(['is_impersonating' => true]);

        return redirect()->route('admin.dashboard');
    })->name('impersonate.verify');

    Route::post('/tenants/{tenant}/toggle-status', [LandlordController::class, 'toggleStatus'])->name('landlord.tenants.toggle-status');

    Route::prefix('tenants')->name('landlord.tenants.')->group(function () {
        Route::get('/{tenant}', [LandlordController::class, 'show'])->name('show');
        // Show specific firm details
        Route::get('/{tenant}', [LandlordController::class, 'show'])->name('show');

        // The Impersonate Logic
        Route::post('/{tenant}/impersonate', [LandlordController::class, 'impersonate'])->name('impersonate');
    });
});
// 5. Auth Routes (Login, Register, Password Reset)
require __DIR__ . '/auth.php';
