<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <style>
        .bg-dot-pattern {
            background-image: radial-gradient(#cbd5e1 1px, transparent 1px);
            background-size: 24px 24px;
        }
    </style>

     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-2">
                <div class="p-2 bg-white rounded-lg shadow-sm border border-slate-100">
                    <i class="ph-duotone ph-squares-four text-indigo-600"></i>
                </div>
                <?php echo e(__('Workspace')); ?>

            </h2>
            <div class="hidden md:flex items-center gap-2 text-xs font-bold text-slate-500 bg-white/80 backdrop-blur px-3 py-1.5 rounded-full border border-slate-200 shadow-sm uppercase tracking-wide">
                <i class="ph-bold ph-calendar-blank text-indigo-500"></i>
                <?php echo e(now()->format('l, d M Y')); ?>

            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-10 bg-slate-50 min-h-screen bg-dot-pattern">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-8">

            <div class="flex flex-col md:flex-row justify-between items-end gap-4 relative z-10">
                <div>
                    <h3 class="text-3xl font-black text-slate-900 tracking-tight">
                        Good <?php echo e(now()->format('H') < 12 ? 'Morning' : (now()->format('H') < 17 ? 'Afternoon' : 'Evening')); ?>,
                        <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-600 to-violet-600"><?php echo e(Auth::user()->name); ?></span>
                    </h3>
                    <p class="text-slate-500 text-sm mt-1 font-medium">Your legal practice at a glance.</p>
                </div>
                <div class="flex gap-3">
                    <a href="<?php echo e(route('admin.cases.create')); ?>" class="group relative inline-flex items-center justify-center px-6 py-3 text-sm font-bold text-white transition-all duration-200 bg-slate-900 font-pj rounded-xl focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-slate-900 hover:bg-slate-800 shadow-lg shadow-slate-300/50">
                        <i class="ph-bold ph-plus-circle mr-2 text-lg"></i> New Matter
                        <div class="absolute -inset-3 rounded-xl bg-gradient-to-r from-indigo-600 to-violet-600 opacity-20 group-hover:opacity-40 blur-lg transition-opacity duration-200"></div>
                    </a>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">

                <div class="relative bg-white rounded-2xl p-6 shadow-[0_8px_30px_rgb(0,0,0,0.04)] border border-slate-100 group hover:border-blue-200 transition-all duration-300">
                    <div class="absolute top-0 right-0 p-4 opacity-5 group-hover:opacity-10 transition-opacity">
                        <i class="ph-duotone ph-briefcase text-8xl text-blue-600 transform rotate-12"></i>
                    </div>
                    <div class="relative z-10">
                        <div class="flex items-center gap-3 mb-2">
                            <div class="h-8 w-8 rounded-full bg-blue-50 flex items-center justify-center text-blue-600">
                                <i class="ph-bold ph-briefcase"></i>
                            </div>
                            <span class="text-xs font-bold text-slate-400 uppercase tracking-wider">Active Files</span>
                        </div>
                        <h4 class="text-3xl font-black text-slate-800 tracking-tight"><?php echo e($stats['active_cases']); ?></h4>
                        <div class="mt-2 flex items-center text-[10px] font-bold text-slate-400">
                            <span class="text-blue-600 bg-blue-50 px-1.5 py-0.5 rounded mr-2">Live</span>
                            Currently open matters
                        </div>
                    </div>
                </div>

                <div class="relative bg-white rounded-2xl p-6 shadow-[0_8px_30px_rgb(0,0,0,0.04)] border border-slate-100 group hover:border-amber-200 transition-all duration-300">
                    <div class="absolute top-0 right-0 p-4 opacity-5 group-hover:opacity-10 transition-opacity">
                        <i class="ph-duotone ph-invoice text-8xl text-amber-600 transform rotate-12"></i>
                    </div>
                    <div class="relative z-10">
                        <div class="flex items-center gap-3 mb-2">
                            <div class="h-8 w-8 rounded-full bg-amber-50 flex items-center justify-center text-amber-600">
                                <i class="ph-bold ph-warning-circle"></i>
                            </div>
                            <span class="text-xs font-bold text-slate-400 uppercase tracking-wider">Receivables</span>
                        </div>
                        <h4 class="text-3xl font-black text-slate-800 tracking-tight font-mono">
                            <span class="text-base text-slate-400 align-top mr-1">KES</span><?php echo e(number_format($stats['pending_revenue'])); ?>

                        </h4>
                        <div class="mt-2 flex items-center text-[10px] font-bold text-slate-400">
                            <span class="text-amber-600 bg-amber-50 px-1.5 py-0.5 rounded mr-2">Pending</span>
                            Unpaid invoices
                        </div>
                    </div>
                </div>

                <div class="relative bg-white rounded-2xl p-6 shadow-[0_8px_30px_rgb(0,0,0,0.04)] border border-slate-100 group hover:border-purple-200 transition-all duration-300">
                    <div class="absolute top-0 right-0 p-4 opacity-5 group-hover:opacity-10 transition-opacity">
                        <i class="ph-duotone ph-files text-8xl text-purple-600 transform rotate-12"></i>
                    </div>
                    <div class="relative z-10">
                        <div class="flex items-center gap-3 mb-2">
                            <div class="h-8 w-8 rounded-full bg-purple-50 flex items-center justify-center text-purple-600">
                                <i class="ph-bold ph-files"></i>
                            </div>
                            <span class="text-xs font-bold text-slate-400 uppercase tracking-wider">Knowledge Base</span>
                        </div>
                        <h4 class="text-3xl font-black text-slate-800 tracking-tight"><?php echo e($stats['documents_count']); ?></h4>
                        <div class="mt-2 flex items-center text-[10px] font-bold text-slate-400">
                            <span class="text-purple-600 bg-purple-50 px-1.5 py-0.5 rounded mr-2">Indexed</span>
                            Total files stored
                        </div>
                    </div>
                </div>

                <div class="relative bg-white rounded-2xl p-6 shadow-[0_8px_30px_rgb(0,0,0,0.04)] border border-slate-100 group hover:border-emerald-200 transition-all duration-300">
                    <div class="absolute top-0 right-0 p-4 opacity-5 group-hover:opacity-10 transition-opacity">
                        <i class="ph-duotone ph-trend-up text-8xl text-emerald-600 transform rotate-12"></i>
                    </div>
                    <div class="relative z-10">
                        <div class="flex items-center gap-3 mb-2">
                            <div class="h-8 w-8 rounded-full bg-emerald-50 flex items-center justify-center text-emerald-600">
                                <i class="ph-bold ph-wallet"></i>
                            </div>
                            <span class="text-xs font-bold text-slate-400 uppercase tracking-wider">Cash (This Month)</span>
                        </div>
                        <h4 class="text-3xl font-black text-emerald-600 tracking-tight font-mono">
                            <span class="text-base text-emerald-600/60 align-top mr-1">KES</span><?php echo e(number_format($stats['monthly_revenue'])); ?>

                        </h4>
                        <div class="mt-2 flex items-center text-[10px] font-bold text-slate-400">
                            <span class="text-emerald-600 bg-emerald-50 px-1.5 py-0.5 rounded mr-2">Collected</span>
                            Actual revenue
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <div class="lg:col-span-2 bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-2xl p-6 relative overflow-hidden">
                    <div class="flex justify-between items-center mb-6 relative z-10">
                        <h4 class="font-bold text-slate-800 flex items-center gap-2">
                            <div class="p-1.5 bg-indigo-50 rounded-lg text-indigo-600">
                                <i class="ph-bold ph-chart-line-up"></i>
                            </div>
                            Revenue Trend
                        </h4>
                        <span class="text-[10px] font-bold uppercase tracking-widest text-slate-400">Last 6 Months</span>
                    </div>
                    <div class="relative h-72 w-full z-10">
                        <canvas id="revenueChart"></canvas>
                    </div>
                    <div class="absolute -bottom-10 -right-10 w-64 h-64 bg-indigo-50 rounded-full mix-blend-multiply filter blur-3xl opacity-50 pointer-events-none"></div>
                </div>

                <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-2xl p-6 relative overflow-hidden">
                     <div class="flex justify-between items-center mb-6 relative z-10">
                        <h4 class="font-bold text-slate-800 flex items-center gap-2">
                            <div class="p-1.5 bg-slate-50 rounded-lg text-slate-600">
                                <i class="ph-bold ph-chart-pie-slice"></i>
                            </div>
                            Case Load
                        </h4>
                    </div>
                    <div class="relative h-64 w-full flex justify-center z-10">
                        <canvas id="statusChart"></canvas>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                <div class="lg:col-span-2 bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-2xl overflow-hidden">
                    <div class="px-6 py-5 border-b border-slate-100 flex justify-between items-center bg-white">
                        <h4 class="font-bold text-slate-800 flex items-center gap-2">
                            <i class="ph-duotone ph-clock-counter-clockwise text-indigo-500"></i> Recent Activity
                        </h4>
                        <a href="<?php echo e(route('admin.cases.index')); ?>" class="text-[10px] font-bold text-indigo-600 hover:bg-indigo-50 px-3 py-1.5 rounded-lg border border-transparent hover:border-indigo-100 transition">View All Cases</a>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-left text-sm font-light">
                            <thead class="bg-slate-50 text-slate-500 font-semibold border-b border-slate-100">
                                <tr>
                                    <th class="px-6 py-4 text-[10px] uppercase tracking-wider">Matter</th>
                                    <th class="px-6 py-4 text-[10px] uppercase tracking-wider">Client</th>
                                    <th class="px-6 py-4 text-[10px] uppercase tracking-wider">Status</th>
                                    <th class="px-6 py-4 text-right"></th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-100">
                                <?php $__empty_1 = true; $__currentLoopData = $recent_cases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="hover:bg-slate-50/50 transition group">
                                        <td class="px-6 py-4">
                                            <div class="font-bold text-slate-700 text-sm group-hover:text-indigo-600 transition"><?php echo e($case->case_number); ?></div>
                                            <div class="text-xs text-slate-400 font-medium truncate max-w-[200px]"><?php echo e($case->title); ?></div>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="flex items-center gap-2">
                                                <div class="h-6 w-6 rounded-md bg-gradient-to-br from-slate-100 to-slate-200 flex items-center justify-center text-[10px] font-bold text-slate-600 border border-slate-200">
                                                    <?php echo e(substr($case->client->name, 0, 1)); ?>

                                                </div>
                                                <span class="text-slate-600 text-sm font-medium"><?php echo e($case->client->name); ?></span>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4">
                                            <?php
                                                $colors = match($case->status) {
                                                    'open' => 'bg-emerald-50 text-emerald-700 ring-emerald-600/20',
                                                    'closed' => 'bg-slate-100 text-slate-600 ring-slate-500/20',
                                                    'hearing' => 'bg-amber-50 text-amber-700 ring-amber-600/20',
                                                    default => 'bg-gray-50 text-gray-600 ring-gray-500/20'
                                                };
                                            ?>
                                            <span class="inline-flex items-center rounded-md px-2 py-1 text-xs font-medium ring-1 ring-inset <?php echo e($colors); ?>">
                                                <?php echo e(ucfirst($case->status)); ?>

                                            </span>
                                        </td>
                                        <td class="px-6 py-4 text-right">
                                            <a href="<?php echo e(route('admin.cases.show', $case->id)); ?>" class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white text-slate-400 shadow-sm ring-1 ring-slate-900/5 hover:text-indigo-600 hover:ring-indigo-200 transition">
                                                <i class="ph-bold ph-arrow-right"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="px-6 py-12 text-center">
                                            <div class="mx-auto h-12 w-12 text-slate-300">
                                                <i class="ph-duotone ph-folder-dashed text-4xl"></i>
                                            </div>
                                            <p class="mt-2 text-sm font-medium text-slate-500">No recent cases found.</p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-2xl p-6 relative overflow-hidden border-t-4 border-rose-500">
                    <h4 class="font-bold text-slate-800 mb-6 flex items-center gap-2">
                        <i class="ph-duotone ph-gavel text-rose-500"></i> Upcoming Hearings
                    </h4>

                    <div class="relative space-y-4">
                        <?php if($upcoming_hearings->count() > 0): ?>
                            <div class="absolute left-[22px] top-4 bottom-4 w-0.5 bg-slate-100 -z-0"></div>
                        <?php endif; ?>

                        <?php $__empty_1 = true; $__currentLoopData = $upcoming_hearings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hearing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="relative flex items-start gap-4 z-10 group">
                                <div class="bg-white text-rose-600 rounded-xl h-12 w-12 flex flex-col items-center justify-center shadow-sm ring-1 ring-slate-200 group-hover:ring-rose-200 group-hover:shadow-md transition duration-300 flex-shrink-0">
                                    <span class="text-[9px] font-bold uppercase tracking-wider text-slate-400"><?php echo e($hearing->court_date->format('M')); ?></span>
                                    <span class="text-lg font-black leading-none"><?php echo e($hearing->court_date->format('d')); ?></span>
                                </div>

                                <div class="flex-1 min-w-0 bg-slate-50 rounded-xl p-3 border border-transparent group-hover:bg-white group-hover:border-slate-100 group-hover:shadow-sm transition duration-300">
                                    <div class="flex justify-between items-start">
                                        <h5 class="text-sm font-bold text-slate-800 truncate"><?php echo e($hearing->case_number); ?></h5>
                                        <a href="<?php echo e(route('admin.cases.show', $hearing->id)); ?>" class="text-slate-300 hover:text-rose-600 transition">
                                            <i class="ph-bold ph-arrow-right"></i>
                                        </a>
                                    </div>
                                    <p class="text-xs text-slate-500 truncate mb-2"><?php echo e($hearing->title); ?></p>
                                    <div class="flex flex-wrap gap-2">
                                        <span class="inline-flex items-center gap-1 px-1.5 py-0.5 rounded text-[10px] font-bold bg-white border border-slate-200 text-rose-600">
                                            <i class="ph-fill ph-clock"></i> <?php echo e($hearing->court_date->format('h:i A')); ?>

                                        </span>
                                        <span class="inline-flex items-center gap-1 px-1.5 py-0.5 rounded text-[10px] font-medium bg-white border border-slate-200 text-slate-500 truncate max-w-[100px]">
                                            <i class="ph-fill ph-map-pin"></i> <?php echo e($hearing->court_name ?? 'TBD'); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-center py-10">
                                <div class="bg-rose-50 rounded-full h-16 w-16 flex items-center justify-center mx-auto mb-3 animate-pulse">
                                    <i class="ph-duotone ph-calendar-slash text-3xl text-rose-300"></i>
                                </div>
                                <p class="text-sm font-bold text-slate-500">No hearings coming up.</p>
                                <p class="text-xs text-slate-400">Time to catch up on paperwork!</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Chart.defaults.font.family = "'Inter', sans-serif";
            Chart.defaults.color = '#64748b';

            // REVENUE CHART
            const ctxRev = document.getElementById('revenueChart');
            if(ctxRev) {
                new Chart(ctxRev.getContext('2d'), {
                    type: 'line',
                    data: {
                        labels: <?php echo json_encode($revenueLabels, 15, 512) ?>,
                        datasets: [{
                            label: 'Revenue (KES)',
                            data: <?php echo json_encode($revenueValues, 15, 512) ?>,
                            borderColor: '#4f46e5', // Indigo-600
                            backgroundColor: (context) => {
                                const ctx = context.chart.ctx;
                                const gradient = ctx.createLinearGradient(0, 0, 0, 300);
                                gradient.addColorStop(0, 'rgba(79, 70, 229, 0.15)');
                                gradient.addColorStop(1, 'rgba(79, 70, 229, 0)');
                                return gradient;
                            },
                            borderWidth: 2,
                            tension: 0.4,
                            fill: true,
                            pointBackgroundColor: '#ffffff',
                            pointBorderColor: '#4f46e5',
                            pointBorderWidth: 2,
                            pointRadius: 0,
                            pointHoverRadius: 6
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        interaction: { intersect: false, mode: 'index' },
                        plugins: {
                            legend: { display: false },
                            tooltip: {
                                backgroundColor: '#1e293b',
                                padding: 12,
                                titleFont: { size: 13 },
                                bodyFont: { size: 12 },
                                cornerRadius: 8,
                                displayColors: false,
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                grid: { borderDash: [4, 4], color: '#f1f5f9', drawBorder: false },
                                ticks: { font: { size: 11 } }
                            },
                            x: {
                                grid: { display: false },
                                ticks: { font: { size: 11 } }
                            }
                        }
                    }
                });
            }

            // STATUS CHART
            const ctxStatus = document.getElementById('statusChart');
            if(ctxStatus) {
                new Chart(ctxStatus.getContext('2d'), {
                    type: 'doughnut',
                    data: {
                        labels: <?php echo json_encode($caseLabels, 15, 512) ?>.map(s => s.charAt(0).toUpperCase() + s.slice(1)),
                        datasets: [{
                            data: <?php echo json_encode($caseValues, 15, 512) ?>,
                            backgroundColor: ['#10b981', '#f59e0b', '#64748b', '#ef4444'],
                            borderWidth: 0,
                            hoverOffset: 10
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                position: 'right',
                                labels: { usePointStyle: true, pointStyle: 'circle', boxWidth: 8, font: { size: 12 } }
                            }
                        },
                        cutout: '75%',
                    }
                });
            }
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /Users/yousaf/Documents/GitHub/law-firm-project/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>